
# PlottyBotting for absolute beginners

## I’ve finished my build – now what?

Good question! 
I built my Plottybot with a bit of support from Ben the designer via his blog. All the testing worked, I had the web page on my screen and – now what should I do? 

If you’re in the same place as me, well done you for completing the build. And I hope these bits of information that I picked up will help you get started too.

----

---
## Start by calibrating PlottyBot

There are two calibration buttons at the top of the Plottybot web page. It’s easy to follow the automatic calibration and think that’s the job done. But there's more to do than just set the X-Y locations of the four corners of the plotting space. My pen initially didn’t reach the paper at some points, and drew lines in places when it should have been clear of the paper. That's because the terminals probably won't be completely level, and there is a bit of flex in the Plottybot Y axis. The further out the pen holder gets, the more it droops - that and the terminals are  what we’ll be levelling, plus any unevenness in the bench.

Get your PlottyBot onto the workbench and mark *exactly* where the PlottyBot sits. You can stick some printing paper to the workbench too, if you like. We’re going to be twiddling the adjustable feet underneath the Plottybot to get the pen height right and need everything to go back into about the same spot after each adjustment. 

<p align="center">
<img src="./JPEG/setup.jpg" width="200" height="200" style="padding: 10px;">
</p>

It's worth putting the paper as far to the right as the pen will reach. That will help catch the maximum droop.

<img align="right" src="./JPEG/Mechanics.jpg" width="150" style="padding: 10px;">


Time to reach for the *“Pen height calibrator”*. That’s the small, round part that you printed with all the other .stl files.

If your pen is already "up", move on to "Find the edges". If your pen is "down", scroll down the web page to the "Mechanics" section at the bottom. Choose the button that confirms "I know exactly what I'm doing" - and unless you really do know, make sure you don't alter any of the numbers in the parameters. Near the bottom of that section are two buttons for "Pen up" and "Pen down" - send your pen up. But don't put a pen in just yet.

*By the way, if you  **did** alter any of the numbers and wish you hadn't, choose the button to "Reset to defaults" and all will be as it was before.*

### Find the edges

Now go to the top of the web page and choose *Manual Calibration*.
 
See those four direction buttons? Use them to drive the pen to each of the four sides of your paper, in turn.  Choose the top button when the pen holder is at each named place. 

But ***do not*** set the edge very close to the edge of the paper - you may find either the gondola will bump into a limit switch and not move off it, or plotting may be off the page. 

At this stage, give yourself plenty of space around the edges. When you've had a bit of practice, you'll be ready to set the edges where you really want them.

<img align="right" src="./JPEG/setedges.jpg" width="250" style="padding: 10px;">

### Pen height

After setting the four edges you'll be prompted to set the pen height. This is the important bit, it takes a bit of time, but you won't need to repeat it often, if at all, while PlottyBot stays where it is.

<img align="right" src="./JPEG/setpenheight1.jpg" width="250" style="padding: 10px;">

Send your pen holder up, then choose "go to top left corner". When you get to the corner, slide the calibrator wedge under the holder and load a pen. Adjust the pen so the point is high on the slope, close to the centre of the calibrator.

Now choose "go to the top right corner".

<img align="right" src="./JPEG/setpenheight2.jpg" width="250" style="padding: 10px;">

Underneath the two terminals are the adjustable feet. Screw the top terminal foot in or out until the calibrator touches the pen at about the same spot as it did at the left corner. 

Then choose the button to send the pen to the bottom right corner. Set the pen height there by screwing the bottom terminal adjuster in or out, as before. 

Now choose the button to send the pen to the bottom left corner, and check the pen height there. The first time I did this setting, there was a big difference between the four corners. 

Keep going round the corners and altering the adjustable feet until you get roughly the same pen height at all four. 

When you're happy with your pen height, choose to send the pen down. Adjust the pen in the holder so that the point contacts the paper. 

My favourite way to get my Sharpie gel pen just right is with "Pen down" (if you've already selected "Done adjusting pen height", use the mechanics section), and lightly fasten the pen in place with the point resting on the paper. Now choose "Pen up" and with help from the calibrator lower the pen no more than 1mm and fasten in place. If the pen is too low, the flex in the X axis will cause inaccurate plotting.

Finally choose "Done adjusting pen height". 


Now let's do something with the PlottyBot! 


---

---
## Your first drawing

I think it's best to choose something really easy to start with. We will use the tools Ben has provided for this.

### Let's write something

First you will set up some letters in the "Handwriting typewriter" and then send a little sentence to the plotter.

On the PlottyBot web page scroll down to the typewriter section and find the alphabet characters. They extend way out to the right. 
<img align="left" src="./JPEG/alphabetblank.jpg" width="200" style="padding: 10px;">
<img align="right" src="./JPEG/alphabetB.jpg" width="200" style="padding: 10px;">

Click in the space under "B/42". This tells PlottyBot which letter to define. You'll do the actual writing in the blank space just above, headed "Work area". Draw a capital letter "B" in there. Fortunately there's a "reset" option under the work space, so it's easy to repeat until you get a letter shape and position you're happy with. And "backspace" (or CTRL/Z) will remove the last line or mark we drew, for small adjustments. 

On the left and right of the work area are dotted lines, green on the left and red on the right. They indicate how much space is to be left before and after the letter. Use the chevrons below the work space to nudge the lines into a position you like the look of. 

Keep things simple for the moment and don't click the asterisks, save them for another day. They define the "ligature points" when you want to plot joined-up writing. 

Do the same definition steps for the letters "e" and "n", so that you can send Ben a hand-drawn greeting. 

Now scroll down a bit further to the "Text" field. In there type "Ben Ben". 

<img align="left" src="./JPEG/alphabettyping.jpg" width="400" style="padding: 10px;">

In the middle you will get an "em" space, the default space of the same width as the largest character, unless you've defined the space as you did for the letters.

And don't alter the "Size ratio". The default setting of "1" will do just fine for now.

You're ready to plot!

Scroll up to the areas titled "Draw" and "Plotter code". You will see "Ben Ben" in the "Draw" area, and lots of other stuff in the "Plotter code". 

Check your pen is in position and ready to draw, then choose the "Play" triangle button below the "Draw" area - and watch the magic happen!

<p align="center">
<img src="./JPEG/typedbenben.jpg" width="250" style="padding: 10px;">
</p>

If you want to save the alphabet you've created, scroll back to the Work area and choose the "Save" button. PlottyBot will create a "Flexible Font" file in your device's default download location. The filename will be "ffont.json" (for the first one; later saves will append a sequence number in brackets). And you can choose the "Load a Flexible Font" button to resume where you left off. 

---

---
## Plotter code

While you've still got "Ben Ben" in the PlottyBot and on paper, let's dip into plotter code. 

<p align="center">
<img src="./JPEG/benbencode.jpg" width="400" style="padding: 10px;">
</p>

Look at the Plotter code that the "Handwriting typewriter" produced for you - you'll find there's an awful lot of it. 

The screenshot above shows the first few lines of plotter code that drew my "Ben Ben". Most of the possible instructions are there already.

### Syntax

There are only three possible instructions: pen up, pen down, and move the carriage from where it is to where you want it next.
- pen_up()
- pen_down()
- go_to(x,y)

The x value sets how far from the left edge the pen will go to the right. This will be between 0 and 100.

The y value sets how far up from the bottom edge the pen will go. This will be between 0 and wherever you set the edge during calibration. Your top value is shown at the top of the left side of the "Draw" window.

### Let's underline the "Ben Ben" that you drew.

This is the (abbreviated!) top line of my generated plotter code. Yours will be different from mine: 

- go_to( 1.9, 120.4)

My "B" is drawn starting at the top of the vertical stroke. PlottyBot has calculated that should be 1.9 in from the left edge and 120.4 up from the bottom edge. 

<img align="right" src="./JPEG/plottercodeend.jpg" width="250" style="padding: 10px;">

Now have a look at the (abbreviated) last line of my plotter code in the image to the right: 

- go_to( 70.7, 109.3)

That tells me the second "n" finished 70.7 in from the left, and 109.3 up from the bottom. 


To underline the letters, I need a line to go from roughly x = 1.8 (just left of where the first "B" starts) to 72 (about the end of the last "n") and at y = 107 (a bit below where the lowest part of the "n" is). Adding some instructions to put the pen up and down at the appropriate spots, my underlining code is:

- pen_up()
- go_to( 1.8, 107)
- pen_down()
- go_to( 72, 107)
- pen_up()

While we're at it, let's put a second underline beneath the first, and draw this one from right to left. Adding these lines to the end will move the pen to where I want the second underline to start, drop the pen onto the paper and draw across to the left, then lift the pen for parking:

- go_to( 72, 106)
- pen_down()
- go_to( 1.8, 106)
- pen_up()

<p align="center">
<img src="./JPEG/benbenunderlined.jpg" width="250" style="padding: 10px;">
</p>


Bingo!

If you fancy doing something more with plotter code, how about drawing a box round the edge of your paper? The steps are:   
pen up, go to a corner, pen down, go to all the corners returning to the start, pen up.


If you find things aren't working as you expect, try clearing all the entries in the "Handwriting typewriter" field and the "Plotter code" field before typing in your own code.

And now a couple more things before moving on to complex stuff.

---

---
<img align="right" src="./JPEG/springs.jpg" width="250" style="padding: 10px;">

## Springs

There's no definitely right answer to how strong the springs on the pen slider should be. Their job is to make sure the pen, pencil or whatever your plotting tool is, presses hard enough on the paper to draw what you want. The picture shows three different springs that I've been using. They've all been harvested from click pens that don't work any more.

1. A short spring that I've stretched to just fit over the rod in the slider
2. A longer spring with just a little stretch
3. Two short springs, one with a tiny bit of stretch, to make it fit

Spring 1 (from a cheap pack of kids' gel pens) gives very little push to the pen slider. That works nicely with a Sharpie fine point gel pen. But that pen would probably work OK with no spring - it's heavy enough to bring the pen slider down and definitely marks anything it touches!

Spring 2 came from an advertising freebie ball-point pen and offers a lot more push than the first spring. This on its own is enough to make a hard pencil leave a fine trace, or a soft pencil leave a dark line.

Spring 3 is actually two of the same short springs (from cheap kids' gel pens) as spring 1. They offer more force to the pen slider, more than I can imagine needing. I haven't used them after testing that the servo could handle them.

Try what you've got and see how they go. I've been using a spring on only one rod, that has worked fine and the servo seems to do its job without complaining. As long as the pen is drawing what you want it to, you don't need any more spring force. And the less force you have in the spring, the longer your servo should last.

---

---
## Belt tension
<img align="right" src="./JPEG/belttension1.jpg" width="250" style="padding: 10px;">


Just how tight should the drive belt be? There's no scientific answer that ordinary people like me can use. The best way to make sure the tension is reasonable is to do a little test when the PlottyBot is switched off.

Push gently to move the gondola most of the way towards one end of the Y-axis, and push gently to move the pen assembly towards the gondola. That will give you a long-ish loop of belt between the adjuster and the gondola. Then with finger and thumb in the centre of each of the long loops, feel how much pressure is needed to make the two sides of the belt touch. It's hard to describe how much is right - "not too little and not too much" just about sums it up. If there's a lot of tension in the belt, screw the adjuster out a little. If the two sides of the belt feel slack and readily touch each other, screw the adjuster in a little. 

My 3D printer was factory built and I've tensioned my PlottyBot belt to feel similar to the one on the printer. 

Give the gondola and pen assembly a little jiggle in and out, then have another feel of the belt. When you're happy with that, it's time to move on to something where the belt tension might be a bit more important.



---

---

## Plot a picture

The steps are:

- find a picture
- make it plottable
- save as an svg file
- convert the svg to Gcode
- send the Gcode to PlottyBot

And now I haven't got a clue, so I'm off Googling.

See you....whenever ;-)